/* Figure */
/* declares */
#declare NULL = 0;
/* Figure */
#declare IMPORT_SPATCH = on
#include "flannel-first.pov"

#declare RIGHT = 0;
#declare LEFT = 1;
#declare LENG = 0;
#declare ROT = 1;
#declare FIRST = 0;
#declare SECOND = 1;
#declare THIRD = 2;
#declare FOURTH = 3;
#declare FIFTH = 4;
#declare FINGERS = 0;
#declare TOES = 1;
#declare ARMS = 0;
#declare LEGS = 1;
//temporary
#declare SHOULDERWIDTH = 15;
#declare WRISTWIDTH = 2;
#declare THICK = 1;
#declare DETAILEDHAND = true;
#declare DETAILEDARM = true;
#declare DETAILEDTORSO = true;
//fingers or toes,which side,which finger,which joint
#declare digitLeng = array[2][2][5][4]{ { { {1.125,1.5,3.25,NULL},			//right thumb length
									    	{1,1,2,4},			//right index length
										    {1,1.25,2,4},			//right middle length
										    {1,1.25,2,3.75},			//right ring length
										    {1,1,1.5,3.5} },		//right pinky length
									      { {1.125,1.25,3.25,NULL},			//left thumb length
									        {1,1,2,4},			//left index length
									        {1,1.25,2,4},			//left middle length
									        {1,1.25,2,3.5},			//left ring length
									        {1,1,1.5,3.5} } },     //left pinky length 
								        { { {1.25,1.25,5.5,NULL},			//right big length - 
									        {.5,.75,1.25,5.5},			//right second length
									   	    {.5,.75,1.25,5},			//right third length
									   	    {.5,.5,.5,8},			//right fourth length
									   	    {.5,.5,.5,8} },		//right pinky length
									      { {1.25,1.25,8,NULL},			//left big length
									        {.5,.75,1.25,5.5},			//left second length
									        {.5,.75,1.25,5},			//left third length
									        {.5,.5,1.25,4.75},			//left fourth length
									        {.5,.5,.5,4.5} } } }		//left pinky length ?^

/*fist{ { { {60*x,30*x,-30*x-20*z,NULL*x},			//right thumb rotation
		 						 	       {-70*z,5*x-120*z,7.5*x-80*z,-15*x},			//right index rotation
								 	       {-85*z,-110*z,-90*z+2.5*x,-5*x},			//right middle rotation
								 	       {-85*z,-5*x-100*z,-90*z,5*x},			//right ring rotation
								 	       {-85*z,-5*x-90*z,-7.5*x-85*z,17.55*x} },		//right pinky rotation*/

								 	     
/*#declare digitRot = array[2][2][5][4]{ { { {15*x,10*x,-40*x-20*z,NULL*x},			//right thumb rotation
								 	       {-5*z,5*x-10*z,7.5*x-10*z,-17.5*x},			//right index rotation
								 	       {-5*z,-5*z,-10*z+2.5*x,-5*x},			//right middle rotation
								 	       {-5*z,-5*x-10*z,-10*z,5*x},			//right ring rotation
								 	       {-5*z,-5*x-12.5*z,-7.5*x-10*z,20*x} },		//right pinky rotation
								 	       								 	       
									     { {-10*x,-10*x,-42.5*x,NULL*x},			//left thumb rotation
									       {5*z,-5*x+10*z,-5*x+15*z,-12.5*x},			//left index rotation
									       {5*z,5*z,10*z,0*x},			//left middle rotation
									       {5*z,5*x+10*z,15*z,10*x},			//left ring rotation
									       {5*z,5*x+12.5*z,5*x+17.5*z,25*x} } },	//left pinky rotation
									       
									   { { {0*x,0*x,-5*z,NULL*x},			//right big rotation
								 	       {0*x,0*x,0*x,0*x},			//right second rotation
								 	       {0*x,0*x,0*x,5*z},			//right third rotation
								 	       {0*x,0*x,0*x,10*z},			//right fourth rotation
								 	       {0*x,0*x,0*x,15*z} },		//right pinky rotation
									     { {0*x,0*x,-5*z,NULL*x},			//left big rotation
									       {0*x,0*x,0*x,0*x},			//left second rotation
									       {0*x,0*x,0*x,5*z},			//left third rotation
									       {0*x,0*x,0*x,10*z},			//left fourth rotation
									       {0*x,0*x,0*x,15*z} } } }	//left pinky rotation*/
#declare digitRot = array[2][2][5][4]{ { { {15*x,10*x+30*y      ,-25*x-70*y  ,NULL*x},			//right thumb rotation
								 	       {-5*z,5*x-10*z  ,7.5*x-30*z  ,-17.5*x-70*y+30*z},			//right index rotation
								 	       {-5*z,-5*z      ,-30*z+2.5*x ,-5*x-70*y+30*z},			//right middle rotation
								 	       {-5*z,-5*x-10*z  ,-30*z      ,5*x-70*y+30*z},			//right ring rotation
								 	       {-5*z,-5*x-12.5*z,-7.5*x-30*z,20*x-70*y+30*z} },		//right pinky rotation
								 	       								 	       
									     { {30*x-5*z,-2*x-20*z+21*x,-10*x+30*z+5*z+20*x+15*y,NULL*x},			//left thumb rotation
									       {10*z     ,+34*z ,28*z+12*x  ,-10*x-30*z+5*z+20*x+15*y},			//left index rotation
									       {10*z     ,33*z     ,25*z+x       ,-32*z+5*z+20*x+15*y},			//left middle rotation
									       {10*z     ,-3*x+34*z    ,-5*x+28*z      ,7.5*x-30*z+5*z+20*x+15*y},			//left ring rotation
									       {10*z     ,-5*x+33*z    ,-12*x+30*z     ,14*x-27*z+7*z+20*x+15*y} } },	//left pinky rotation
									       
									   { { {0*x,0*x,-5*z,NULL*x},			//right big rotation
								 	       {0*x,0*x,0*x,0*x},			//right second rotation
								 	       {0*x,0*x,0*x,5*z},			//right third rotation
								 	       {0*x,0*x,0*x,10*z},			//right fourth rotation
								 	       {0*x,0*x,0*x,15*z} },		//right pinky rotation
									     { {0*x,0*x,-5*z,NULL*x},			//left big rotation
									       {0*x,0*x,0*x,0*x},			//left second rotation
									       {0*x,0*x,0*x,5*z},			//left third rotation
									       {0*x,0*x,0*x,10*z},			//left fourth rotation
									       {0*x,0*x,0*x,15*z} } } }	//left pinky rotation
									                  
//arms or legs,which side,which part
#declare limbLeng = array[2][2][2]{ { {10,11},		//right arm length
									  {10,11} },		//left arm length
									{ {15.5,15},		//right leg length ?
								      {15.5,15} } }	//left leg length ?
								       
#declare limbRot = array[2][2][2]{ { {-95*x-5*y,-55*x-2*y},		//right arm rotation
								     {-90*x-20*y,-25*x+18*y} },	//left arm rotation
								   { {-5*z,10*z},		//right leg rotation
								     {5*z,-10*z} } }	//left leg rotation
								   
#declare handsfeet = array[2][2]
#declare armslegs = array[2][2]
#declare JOINTTEX = texture{
  pigment{ rgb <255, 185, 140>/255 }
//  normal{ wood .55 turbulence .05 scale .15 }
  normal{ crackle .5 }
  finish{ ambient .1 }
}
#declare DIGITTEX = texture{
  pigment{ rgb <245, 185, 140>/255 }
  normal{
    gradient z
    normal_map{
      [0 wood .05 turbulence .1 scale .2]
      [.25 wood .05 turbulence .1 scale .2]
      [.5 wood .01 scale .01]
      [.75 wood .05 turbulence .1 scale .2]
      [1 wood .05 turbulence .1 scale .2]
    }
  }
  scale .5
  finish{ ambient .1 }
}
#declare HANDTEX = texture{
  pigment{ rgb <245, 185, 140>/255 }
  normal{ crackle .15 scale .05 }
  finish{ ambient .1 }
}
#declare KNUCKLETEX = HANDTEX/*texture{
  pigment{ rgb <255, 185, 140>/255 }
  normal{ crackle .5 }
}*/

#declare PALMTEX = HANDTEX
#declare ARMTEX = texture{
	  gradient y
	  scale <1, 2.55, 1>
	  translate -y
	  texture_map{
	    [0 pigment{
	         quilted
	         turbulence 1
	         scale .1
	         color_map{
	          [0 red .5]
	          [1 red .4]
	         }
	       }
	       	         normal{
	           radial .075
	           frequency 125
	         } finish{ ambient .1 }
	    ]  
	    [.82 pigment{
	            quilted
	            turbulence 1
	            scale .1
	            color_map{
	             [0 red .5]
	             [1 red .4]
	            }
	          }
	          	         normal{
	           radial .075
	           frequency 125
	         } finish{ ambient .1 }
	    ]
	    //[.84 pigment{ rgb 1 }]
	    [.84 pigment{
	           radial
	           frequency 100
	           color_map{
	             [0 rgb 0]
	             [1 rgb <1, 0, 0>]
	           }
	         } finish{ ambient .1 }
	    ]
	    [.85 pigment{
	           quilted
	           turbulence 1
	           scale .1
	           color_map{
	             [0 red .5]
	             [1 red .4]
	           }
	         }
	         normal{
	           radial .5
	           frequency 75
	         } finish{ ambient .1 }
	    ]
	    [1 pigment{
	           quilted
	           turbulence 1
	           scale .1
	           color_map{
	             [0 red .5]
	             [1 red .4]
	           }
	         }
	         normal{
	           radial .5
	           frequency 75
	         }finish{ ambient .1 }]
	     
      }
	  //normal{ bumps 1 turbulence 1 scale .05 }
	  
	}
/* camera */
//camera{ location <15, -10, 35> look_at 15*x-10*y }
//*relexed*/camera{ location <-10, -3.75, 0> look_at -3.75*y }
//camera{ location <7, -5, 4> look_at -3.75*y }
//camera{ location <0, -4, -10> look_at -4*y }
//camera{ location <3, -7, 4> look_at -3*y+z }
/* light sources */
//light_source{ 20*z rgb 1 }

//light_source{ <-10, -3, 3> rgb 1 }
//light_source{ <-10, -8, 0> rgb 1 }

/* objects */
// hands and feet
#local cnt0 = 0; #while( cnt0 < 2 )
  #local cnt1 = 0; #while( cnt1 < 2 )
    #declare handsfeet[cnt0][cnt1] = union{
      // thumb or big toe
      #ifdef( DETAILEDHAND )
        blob{
          threshold .5
          #local cnt3 = 0; #while( cnt3 < 2 )
            sphere{
              digitLeng[cnt0][cnt1][FIRST][cnt3]*y, .65, -.825
              //<--
              texture{ JOINTTEX }
              #local temp = 0; #while( temp < ( 3 - cnt3 ) )
                translate -digitLeng[cnt0][cnt1][FIRST][cnt3+temp]*y
                rotate digitRot[cnt0][cnt1][FIRST][cnt3+temp]
              #local temp = temp + 1; #end
            }
            cylinder{
              0, digitLeng[cnt0][cnt1][FIRST][cnt3]*y, .65, 1
              texture{ DIGITTEX }
              #local temp = 0; #while( temp < ( 3 - cnt3 ) )
                translate -digitLeng[cnt0][cnt1][FIRST][cnt3+temp]*y
                rotate digitRot[cnt0][cnt1][FIRST][cnt3+temp]
              #local temp = temp + 1; #end
            }
          #local cnt3 = cnt3 + 1; #end
          //maybe
          translate ( 2 - FIRST )*WRISTWIDTH/16*z //+.0625*y
        }
      #else
        #local cnt3 = 2; #while( cnt3 > -1 )
          union{
            cylinder{ 0, digitLeng[cnt0][cnt1][FIRST][cnt3]*y, THICK }
        #local cnt3 = cnt3 - 1; #end
        #local cnt3 = 0; #while( cnt3 < 3 )
            translate -digitLeng[cnt0][cnt1][FIRST][cnt3]*y
            rotate digitRot[cnt0][cnt1][FIRST][cnt3]
          }
        #local cnt3 = cnt3 + 1; #end
      #end
      // rest
      #local cnt2 = 1; #while( cnt2 < 5 )
        #ifdef( DETAILEDHAND )
          blob{
            threshold .5
            #local cnt3 = 0; #while( cnt3 < 3 )
              sphere{
                digitLeng[cnt0][cnt1][cnt2][cnt3]*y, .575, -.9//+cnt3/50, -.9
                texture{ JOINTTEX }
                #local temp = 0; #while( temp < ( 4 - cnt3 ) )
                  translate -digitLeng[cnt0][cnt1][cnt2][cnt3+temp]*y
                  rotate digitRot[cnt0][cnt1][cnt2][cnt3+temp]
                #local temp = temp + 1; #end
              }
              cylinder{
                0, digitLeng[cnt0][cnt1][cnt2][cnt3]*y, .575 ,1//+cnt3/50, 1
                texture{ DIGITTEX }
                #local temp = 0; #while( temp < ( 4 - cnt3 ) )
                  translate -digitLeng[cnt0][cnt1][cnt2][cnt3+temp]*y
                  rotate digitRot[cnt0][cnt1][cnt2][cnt3+temp]
                #local temp = temp + 1; #end
              }
            #local cnt3 = cnt3 + 1; #end
            //maybe
            translate ( 2 - cnt2 )*WRISTWIDTH/16*z //+.0625*y
          }
        #else
          #local cnt3 = 3; #while( cnt3 > -1 )
            union{
              cylinder{ 0, digitLeng[cnt0][cnt1][cnt2][cnt3]*y, THICK }
          #local cnt3 = cnt3 - 1; #end
          #local cnt3 = 0; #while( cnt3 < 4 )
              translate -digitLeng[cnt0][cnt1][cnt2][cnt3]*y
              rotate digitRot[cnt0][cnt1][cnt2][cnt3]
            }
          #local cnt3 = cnt3 + 1; #end
        #end
      #local cnt2 = cnt2 + 1; #end
      
      #if( cnt0 = FINGERS ) #ifdef( DETAILEDHAND )
      
        blob{
        threshold .5
        // ?bones on hand
          // thumb
          sphere{
            0, .5, 1
            texture{ HANDTEX }
            scale <1.75, 1.625*digitLeng[cnt0][cnt1][FIRST][THIRD], 1.5>
            translate -.625*digitLeng[cnt0][cnt1][FIRST][THIRD]*y
            rotate digitRot[cnt0][cnt1][FIRST][THIRD]-digitRot[cnt0][cnt1][FIRST][SECOND]/15	//can't be too high
            translate ( 2 - FIRST )*WRISTWIDTH/16*z //-.0625*x
          }
          // rest
          #local cnt3 = 1; #while( cnt3 < 5 )
            sphere{
              0, .5, 1
              texture{ HANDTEX }
              scale <1.75, 1.625*digitLeng[cnt0][cnt1][cnt3][FOURTH], 1.5>		//little longer to make the webbing between fingers
              translate -.625*digitLeng[cnt0][cnt1][cnt3][FOURTH]*y
              rotate digitRot[cnt0][cnt1][cnt3][FOURTH]-digitRot[cnt0][cnt1][cnt3][THIRD]/15	//can't be too high
              translate ( 2 - cnt3 )*WRISTWIDTH/16*z //-.0625*x
            }
          #local cnt3 = cnt3 + 1; #end
          // knuckles
          // thumb
          sphere{
            0, .5, 1
            texture{ KNUCKLETEX }
            scale <1.15, 1.30, 1.15>
            rotate digitRot[cnt0][cnt1][FIRST][SECOND]
            translate -digitLeng[cnt0][cnt1][FIRST][THIRD]*y
            rotate digitRot[cnt0][cnt1][FIRST][THIRD]
            translate ( 2 - FIRST )*WRISTWIDTH/16*z
          }
          // rest
          #local cnt3 = 1; #while( cnt3 < 5 )
            sphere{
              0, .5, 1
              texture{ KNUCKLETEX }
              scale <.875, 1.30, .875>
              rotate digitRot[cnt0][cnt1][cnt3][THIRD]
              translate -digitLeng[cnt0][cnt1][cnt3][FOURTH]*y
              rotate digitRot[cnt0][cnt1][cnt3][FOURTH]
              translate ( 2 - cnt3 )*WRISTWIDTH/16*z
            }
          #local cnt3 = cnt3 + 1; #end
          //thumb webbing
          #local aone = digitLeng[cnt0][cnt1][SECOND][FOURTH];
          #local atwo = digitLeng[cnt0][cnt1][FIRST][THIRD];
          #local rate = .05; #while( rate <= 1 )
            sphere{
              0, .5, 1
              texture{ HANDTEX }
              scale <.575, (.6+abs(.5-rate)*.8)*(aone*rate+atwo*(1-rate)), 1>
              translate -(atwo*rate+aone*(1-rate))/2*y
              rotate digitRot[cnt0][cnt1][FIRST][THIRD]*rate+digitRot[cnt0][cnt1][SECOND][FOURTH]*(1-rate)
              //translate ( 2 - (FIRST*rate+SECOND*(1-rate)) )*WRISTWIDTH/16*z
              translate ( 2- FIRST )*WRISTWIDTH/16*z
            }
          #local rate = rate + .1; #end
        }
        
        blob{
          threshold .25
          /*thumb webbing
          #local rate = .1; #while( rate <= .9 )
            sphere{
              0, .5, 1
              texture{ HANDTEX }//pigment{ blue 1 } }
              scale <.5, (digitLeng[cnt0][cnt1][SECOND][FOURTH]*rate+digitLeng[cnt0][cnt1][FIRST][THIRD]*(1-rate)), 1>
              translate -(digitLeng[cnt0][cnt1][FIRST][THIRD]*rate+digitLeng[cnt0][cnt1][SECOND][FOURTH]*(1-rate))/2*y
              translate y
              rotate digitRot[cnt0][cnt1][FIRST][THIRD]*rate+digitRot[cnt0][cnt1][SECOND][FOURTH]*(1-rate)
              translate ( 2 - (FIRST*rate+THIRD*(1-rate)) )*WRISTWIDTH/16*z
            }
          #local rate = rate + .1; #end*/
          //thumb
          sphere{
            0, .5, 1
            texture{ KNUCKLETEX }
            scale <.875, 1.75, .875>
            rotate digitRot[cnt0][cnt1][FIRST][SECOND]
            translate -digitLeng[cnt0][cnt1][FIRST][THIRD]*y
            rotate digitRot[cnt0][cnt1][FIRST][THIRD]
            translate ( 2 - FIRST )*WRISTWIDTH/16*z -.0625*x
          } //knuckle
          sphere{
            0, .5, 1
            texture{ HANDTEX }
            scale <.875, 1.75*digitLeng[cnt0][cnt1][FIRST][THIRD], 1.25>
            translate -digitLeng[cnt0][cnt1][FIRST][THIRD]/2*y
            rotate digitRot[cnt0][cnt1][FIRST][THIRD]
            translate ( 2 - FIRST )*WRISTWIDTH/16*z -.0625*x
          }
          sphere{
            0, .5, 1
            texture{ PALMTEX }
            scale <.875, digitLeng[cnt0][cnt1][FIRST][THIRD], 1.25>
            translate -digitLeng[cnt0][cnt1][FIRST][THIRD]/3*y
            rotate digitRot[cnt0][cnt1][FIRST][THIRD]
            translate ( 2 - FIRST )*WRISTWIDTH/16*z -.0625*x -.25*x
          }
          /*sphere{
            0, .5, 1
            texture{ HANDTEX }
            scale <.75, 1.5*digitLeng[cnt0][cnt1][FIRST][THIRD], 1>
            translate -digitLeng[cnt0][cnt1][FIRST][THIRD]/2*y
            rotate digitRot[cnt0][cnt1][FIRST][THIRD]-digitRot[cnt0][cnt1][FIRST][SECOND]/15
            translate ( 2 - FIRST )*WRISTWIDTH/16*z //-.0625*x
          } //bone*/
          //<--- smooth out the knuckles
          cylinder{
            0, digitLeng[cnt0][cnt1][FIRST][SECOND]*y, .65, .5
            texture{ HANDTEX }
            #local temp = 0; #while( temp < 2 )
              translate -digitLeng[cnt0][cnt1][FIRST][SECOND+temp]*y
              rotate digitRot[cnt0][cnt1][FIRST][SECOND+temp]
            #local temp = temp + 1; #end
            translate ( 2 - FIRST )*WRISTWIDTH/16*z
          }
          #local cnt3 = 1; #while( cnt3 < 5 )
            cylinder{
              0, digitLeng[cnt0][cnt1][cnt3][THIRD]*y, .575, .5
              texture{ HANDTEX }
              #local temp = 0; #while( temp < 2 )
                translate -digitLeng[cnt0][cnt1][cnt3][THIRD+temp]*y
                rotate digitRot[cnt0][cnt1][cnt3][THIRD+temp]
              #local temp = temp + 1; #end
              translate ( 2 - cnt3 )*WRISTWIDTH/16*z //+.0625*y
            }
          #local cnt3 = cnt3 + 1; #end
          //-->
          //index
          sphere{
            0, .5, 1
            texture{ KNUCKLETEX }
            scale <.925, 1.75, .925>
            rotate digitRot[cnt0][cnt1][SECOND][THIRD]
            translate -digitLeng[cnt0][cnt1][SECOND][FOURTH]*y
            rotate digitRot[cnt0][cnt1][SECOND][FOURTH]
            translate ( 2 - SECOND )*WRISTWIDTH/16*z -.125*x
          } //knuckle
          sphere{
            0, .5, 1
            texture{ PALMTEX }
            scale <.875, 1.5*digitLeng[cnt0][cnt1][SECOND][FOURTH], 1>
            translate -digitLeng[cnt0][cnt1][SECOND][FOURTH]/2*y
            rotate digitRot[cnt0][cnt1][SECOND][FOURTH]
            translate ( 2 - SECOND )*WRISTWIDTH/16*z -.3*x
          }
          sphere{
            0, .5, 1
            texture{ HANDTEX }
            scale <.75, 1.5*digitLeng[cnt0][cnt1][SECOND][FOURTH], .75>
            translate -digitLeng[cnt0][cnt1][SECOND][FOURTH]/2*y
            rotate digitRot[cnt0][cnt1][SECOND][FOURTH]-digitRot[cnt0][cnt1][SECOND][THIRD]/15
            translate ( 2 - SECOND )*WRISTWIDTH/16*z //-.0625*x
          } //bone
          /*cylinder{
            0, -digitLeng[cnt0][cnt1][SECOND][FOURTH]*y, .5, 1
            scale <.6, 1, 1>
            rotate digitRot[cnt0][cnt1][SECOND][FOURTH]
          }*/
          //middle
          sphere{
            0, .5, 1
            texture{ KNUCKLETEX }
            scale <1, 1.75, .875>
            rotate digitRot[cnt0][cnt1][THIRD][THIRD]
            translate -digitLeng[cnt0][cnt1][THIRD][FOURTH]*y
            rotate digitRot[cnt0][cnt1][THIRD][FOURTH]
            translate ( 2 - THIRD )*WRISTWIDTH/16*z -.125*x
          } //knuckle
          sphere{
            0, .5, 1
            texture{ HANDTEX }
            scale <1, .625*digitLeng[cnt0][cnt1][THIRD][FOURTH], 3>
            translate -3*digitLeng[cnt0][cnt1][THIRD][FOURTH]/4*y
            rotate digitRot[cnt0][cnt1][THIRD][FOURTH]-digitRot[cnt0][cnt1][THIRD][THIRD]/30
            translate ( 2 - THIRD )*WRISTWIDTH/16*z -.0625*x
          }
          /*sphere{
            0, .5, 1
            texture{ HANDTEX }
            scale <1, 1.5*digitLeng[cnt0][cnt1][THIRD][FOURTH], 3>
            translate -digitLeng[cnt0][cnt1][THIRD][FOURTH]/2*y
            rotate digitRot[cnt0][cnt1][THIRD][FOURTH]-digitRot[cnt0][cnt1][THIRD][THIRD]/30
            translate ( 2 - THIRD )*WRISTWIDTH/16*z -.0625*x
          }
          sphere{
            0, .5, 1
            texture{ PALMTEX }
            scale <1, 1.25*digitLeng[cnt0][cnt1][THIRD][FOURTH], 3>
            translate -digitLeng[cnt0][cnt1][THIRD][FOURTH]/2*y
            rotate digitRot[cnt0][cnt1][THIRD][FOURTH]-digitRot[cnt0][cnt1][THIRD][THIRD]/30
            translate ( 2 - THIRD )*WRISTWIDTH/16*z -.0625*x -.125*x
          }
          sphere{
            0, .5, 1
            texture{ HANDTEX }
            scale <1.25, 1.5*digitLeng[cnt0][cnt1][THIRD][FOURTH], 1>
            translate -digitLeng[cnt0][cnt1][THIRD][FOURTH]/2*y
            rotate digitRot[cnt0][cnt1][THIRD][FOURTH]-digitRot[cnt0][cnt1][THIRD][THIRD]/15
            translate ( 2 - THIRD )*WRISTWIDTH/16*z -.0625*x
          } //bone*/
          //ring
          sphere{
            0, .5, 1
            texture{ KNUCKLETEX }
            scale <1, 1.75, .875>
            rotate digitRot[cnt0][cnt1][FOURTH][THIRD]
            translate -digitLeng[cnt0][cnt1][FOURTH][FOURTH]*y
            rotate digitRot[cnt0][cnt1][FOURTH][FOURTH]
            translate ( 2 - FOURTH )*WRISTWIDTH/16*z -.125*x
          } //knuckle
          sphere{
            0, .5, 1
            texture{ HANDTEX }
            scale <.875, 1.5*digitLeng[cnt0][cnt1][FOURTH][FOURTH], 1>
            translate -digitLeng[cnt0][cnt1][FOURTH][FOURTH]/2*y
            rotate digitRot[cnt0][cnt1][FOURTH][FOURTH]-digitRot[cnt0][cnt1][FOURTH][THIRD]/15
            translate ( 2 - FOURTH )*WRISTWIDTH/16*z //-.0625*x
          } //bone
          //pinky
          sphere{
            0, .5, 1
            texture{ KNUCKLETEX }
            scale <1, 1.75, .875>
            rotate digitRot[cnt0][cnt1][FIFTH][THIRD]
            translate -digitLeng[cnt0][cnt1][FIFTH][FOURTH]*y
            rotate digitRot[cnt0][cnt1][FIFTH][FOURTH]
            translate ( 2 - FIFTH )*WRISTWIDTH/16*z -0.125*x
          } //knuckle
          sphere{
            0, .5, 1
            texture{ HANDTEX }
            scale <.75, 1.625*digitLeng[cnt0][cnt1][FIFTH][FOURTH], 1.75>
            translate -digitLeng[cnt0][cnt1][FIFTH][FOURTH]/2*y
            rotate digitRot[cnt0][cnt1][FIFTH][FOURTH]-digitRot[cnt0][cnt1][FIFTH][THIRD]/20
            translate ( 2 - FIFTH )*WRISTWIDTH/16*z -.0625*x
          }
          sphere{
            0, .5, 1
            texture{ PALMTEX }
            scale <1.25, 1.75*digitLeng[cnt0][cnt1][FIFTH][FOURTH], 1.875>
            translate -digitLeng[cnt0][cnt1][FIFTH][FOURTH]/3*y
            rotate digitRot[cnt0][cnt1][FIFTH][FOURTH]-digitRot[cnt0][cnt1][FIFTH][THIRD]/20
            translate ( 2 - FIFTH )*WRISTWIDTH/16*z -.0625*x -.25*x
          }
          sphere{
            0, .5, 1
            texture{ HANDTEX }
            scale <.875, 1.5*digitLeng[cnt0][cnt1][FIFTH][FOURTH], 1>
            translate -digitLeng[cnt0][cnt1][FIFTH][FOURTH]/2*y
            rotate digitRot[cnt0][cnt1][FIFTH][FOURTH]-digitRot[cnt0][cnt1][FIFTH][THIRD]/15
            translate ( 2 - FIFTH )*WRISTWIDTH/16*z //-.0625*x
          } //bone
        }
        
      #end #end
            
    }
  #local cnt1 = cnt1 + 1; #end
#local cnt0 = cnt0 + 1; #end

#declare RIGHTHAND = handsfeet[FINGERS][RIGHT]
#declare LEFTHAND = handsfeet[FINGERS][LEFT]
#declare RIGHTFOOT = handsfeet[TOES][RIGHT]
#declare LEFTFOOT = handsfeet[TOES][LEFT]

// limbs
#local cnt0 = 0; #while( cnt0 < 2 )
  #local cnt1 = 0; #while( cnt1 < 2 )
    #declare armslegs[cnt0][cnt1] = union{
      #ifdef( DETAILEDARM )
        blob{
          threshold .5
          cylinder{
            0, limbLeng[cnt0][cnt1][SECOND]*y, 2, 1
            scale <.625, 1, 1>
          }
          sphere{
            0, 1, 1
            scale <2, .75*limbLeng[cnt0][cnt1][FIRST], 2>
            translate limbLeng[cnt0][cnt1][FIRST]/2*y
          }
          sphere{
            0, 1, 1
            scale <2, .25*limbLeng[cnt0][cnt1][FIRST], 2>
            translate limbLeng[cnt0][cnt1][FIRST]/8*y
          }
          sphere{
            0, 1, 1
            scale <2.5, .5*limbLeng[cnt0][cnt1][FIRST], 3>
            translate limbLeng[cnt0][cnt1][FIRST]*y
          }
          texture{ ARMTEX }
        }
        union{
          #ifndef( IMPORT_SPATCH )
            blob{
              threshold .5
              cylinder{
                0, limbLeng[cnt0][cnt1][FIRST]*y, 2, 1
                scale <.75, 1, 1>
              }
              sphere{
                0, 1, 1
                scale <2, limbLeng[cnt0][cnt1][FIRST]/2, 1.5>
                translate 2*limbLeng[cnt0][cnt1][FIRST]/3*y
              }
              texture{ ARMTEX }
            }
          #else
            object{
              flannel_first
              translate y
              rotate 180*z
              translate 2.5*y
              scale limbLeng[cnt0][cnt1][FIRST]/2.5
            }
          #end
          object{ handsfeet[cnt0][cnt1] }
          translate - limbLeng[cnt0][cnt1][FIRST]*y
          rotate limbRot[cnt0][cnt1][FIRST]
        }
        translate -limbLeng[cnt0][cnt1][SECOND]*y
        rotate limbRot[cnt0][cnt1][SECOND]
      #else
        cylinder{ 0, limbLeng[cnt0][cnt1][SECOND]*y, THICK }
        union{
          cylinder{ 0, limbLeng[cnt0][cnt1][FIRST]*y, THICK }
          //hands or feet
          object{ handsfeet[cnt0][cnt1] }
          translate -limbLeng[cnt0][cnt1][FIRST]*y
          rotate limbRot[cnt0][cnt1][FIRST]
        }
        translate -limbLeng[cnt0][cnt1][SECOND]*y
        rotate limbRot[cnt0][cnt1][SECOND]
      #end
    }
     
  #local cnt1 = cnt1 + 1; #end
#local cnt0 = cnt0 + 1; #end

#declare RIGHTARM = armslegs[ARMS][RIGHT]
#declare LEFTARM = armslegs[ARMS][LEFT]
#declare RIGHTLEG = armslegs[LEGS][RIGHT]
#declare LEFTLEG = armslegs[LEGS][LEFT]

// torso
#declare TORSO = union{
  #ifdef( DETAILEDTORSO )
    blob{
      threshold .5
      cylinder{
        0, -sqrt( 1+pow( SHOULDERWIDTH/2, 2 ) )*x, 1, 1
        scale <1, 2.5, 2>
        rotate -atan2( 2, SHOULDERWIDTH )*180/pi*z
        translate SHOULDERWIDTH/2*x
      }
      cylinder{
        0, sqrt( 1+pow( SHOULDERWIDTH/2, 2 ) )*x, 1, 1
        scale <1, 2.5, 2>
        rotate atan2( 2, SHOULDERWIDTH )*180/pi*z
        translate -SHOULDERWIDTH/2*x
      }
    }
  #else
    cylinder{
      0, -sqrt( 1+pow( SHOULDERWIDTH/2, 2 ) )*x, THICK
      rotate -atan2( 2, SHOULDERWIDTH )*180/pi*z
      translate SHOULDERWIDTH/2*x
    }
    cylinder{
      0, sqrt( 1+pow( SHOULDERWIDTH/2, 2 ) )*x, THICK
      rotate atan2( 2, SHOULDERWIDTH )*180/pi*z
      translate -SHOULDERWIDTH/2*x
    }
  #end
}

// head
//object{ TORSO pigment{ red 1 } }
//sphere{ 0, 2 pigment{ green 1 } translate SHOULDERWIDTH*x/2 }
union{
  object{ RIGHTARM translate SHOULDERWIDTH*x/2 }
  object{ LEFTARM translate -SHOULDERWIDTH*x/2 }
//  rotate -20*y
  translate <14.75, 8, -18>
//  translate <15, 24, 3>
}

 /*
union{
  difference{
    sphere{
      0, .5
      scale <6+5/8, 3.25*2, 6+5/8>
      pigment{ rgb 0 }
      finish{ specular .9 roughness .001 reflection .2 }
    }
    sphere{
      0, .5
      scale <6+5/8-1/16, 3.25*2-1/16, 6+5/8-1/16>
      pigment{ rgb <.95, .95, 1> }
      finish{ ambient .6 specular 1 roughness .002 reflection .2}
    }
    plane{
      y, 0
    }
    cone{ 2*y, 1.25-1/16, 6.24*y, 1-1/16 }
  }
    rotate <-15, 0, -20>
  translate <20, 13, 2>
}
    
    plane{ y, 0 pigment{ rgb <1, 1, 0 > } }
    cone{ 0, 1.5, 5.5*y, 1.75 
      pigment{ blue 1 }
      rotate <15, 0, -30>
      translate <9, .6875, 3.5>
    }
//object{ RIGHTLEG pigment{ red 1 } translate 5*x-10*y}
//object{ LEFTLEG pigment{ red 1 } translate -5*x-10*y}

camera{
  location <16, 19, -38> //<15, 12, -15>
  look_at <14, 5, 8> //<14, 5, 8>
  angle 35
}

light_source{
  <20, 14, 2>
  //<10, 14, 2>
  rgb <1, 1, .9>
}       */